<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Admin Panel - Shofie Sholeha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <style>
        * {
            font-family: 'Outfit', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #0f0f1e;
            min-height: 100vh;
            padding-top: 80px;
            position: relative;
            overflow-x: hidden;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 50%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(255, 103, 132, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 20%, rgba(138, 122, 255, 0.2) 0%, transparent 50%);
            animation: gradient-shift 15s ease infinite;
            z-index: 0;
            pointer-events: none;
        }

        @keyframes gradient-shift {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        .admin-navbar {
            background: rgba(15, 15, 30, 0.7);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            padding: 20px 0;
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1000;
        }

        .navbar-brand {
            font-size: 1.8rem;
            font-weight: 900;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            display: flex;
            align-items: center;
            gap: 12px;
            letter-spacing: -1px;
            transition: all 0.4s ease;
        }


        @keyframes rotate-icon {
            0%, 100% { transform: rotate(0deg) scale(1); }
            50% { transform: rotate(180deg) scale(1.2); }
        }

        .navbar-brand:hover {
            transform: scale(1.05);
            filter: brightness(1.2);
        }

        
        .nav-link {
            color: rgba(255, 255, 255, 0.7) !important;
            font-weight: 600;
            padding: 12px 24px !important;
            margin: 0 6px;
            border-radius: 30px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-size: 0.95rem;
            letter-spacing: 0.5px;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea, #764ba2);
            transition: all 0.5s ease;
            transform: translate(-50%, -50%);
            z-index: -1;
        }

        .nav-link:hover::before {
            width: 300px;
            height: 300px;
        }

        .nav-link:hover {
            color: white !important;
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .nav-link.active {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white !important;
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
        }

        .btn-frontend {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: rgba(255, 255, 255, 0.9);
            padding: 12px 24px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.4s ease;
            display: flex;
            align-items: center;
            gap: 10px;
            text-decoration: none;
        }

        .btn-frontend:hover {
            background: rgba(255, 255, 255, 0.15);
            border-color: rgba(102, 126, 234, 0.5);
            color: white;
            transform: translateX(-3px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }

        .user-dropdown {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 30px;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
            color: rgba(255, 255, 255, 0.9);
            font-weight: 600;
            font-size: 0.95rem;
            cursor: pointer;
            transition: all 0.4s ease;
        }

        .user-dropdown:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.3);
        }

        .user-icon {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea, #764ba2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .dropdown-menu {
            background: rgba(15, 15, 30, 0.98);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            padding: 12px;
            margin-top: 10px !important;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
        }

        .dropdown-item {
            color: rgba(255, 255, 255, 0.8);
            padding: 12px 18px;
            border-radius: 15px;
            transition: all 0.3s ease;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .dropdown-item:hover {
            background: rgba(102, 126, 234, 0.2);
            color: white;
        }

        .dropdown-item.text-danger {
            color: #f093fb !important;
        }

        .dropdown-item.text-danger:hover {
            background: rgba(240, 147, 251, 0.2);
        }

        .btn-login {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border: none;
            color: white;
            padding: 12px 32px;
            border-radius: 30px;
            font-weight: 700;
            font-size: 0.95rem;
            transition: all 0.4s ease;
            box-shadow: 0 8px 30px rgba(102, 126, 234, 0.4);
            letter-spacing: 0.5px;
        }

        .btn-login:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 40px rgba(102, 126, 234, 0.6);
            color: white;
        }

        .container-main {
            background: rgba(255, 255, 255, 0.03);
            backdrop-filter: blur(20px);
            border-radius: 40px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 
                0 20px 60px rgba(0, 0, 0, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            padding: 50px;
            margin-top: 40px;
            margin-bottom: 40px;
            position: relative;
            z-index: 1;
            min-height: calc(100vh - 280px);
        }

        .admin-footer {
            background: rgba(15, 15, 30, 0.7);
            backdrop-filter: blur(20px);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 30px 0;
            margin-top: 50px;
            position: relative;
            z-index: 1;
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: rgba(255, 255, 255, 0.6);
            font-size: 0.95rem;
        }

        .footer-brand {
            font-weight: 700;
            background: linear-gradient(135deg, #667eea, #764ba2, #f093fb);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .footer-links {
            display: flex;
            gap: 25px;
        }

        .footer-link {
            color: rgba(255, 255, 255, 0.5);
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
            position: relative;
        }

        .footer-link::after {
            content: '';
            position: absolute;
            bottom: -3px;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(90deg, #667eea, #764ba2);
            transition: width 0.3s ease;
        }

        .footer-link:hover {
            color: #f093fb;
        }

        .footer-link:hover::after {
            width: 100%;
        }

        .navbar-toggler {
            border: 2px solid rgba(102, 126, 234, 0.5);
            padding: 10px 14px;
            border-radius: 12px;
            transition: all 0.3s ease;
        }

        .navbar-toggler:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
        }

        .navbar-toggler:focus {
            box-shadow: 0 0 0 0.3rem rgba(102, 126, 234, 0.3);
        }

        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28102, 126, 234, 1%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2.5' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
        }

        .particle {
            position: fixed;
            border-radius: 50%;
            pointer-events: none;
            z-index: 0;
            animation: float-particle 20s infinite ease-in-out;
        }

        .particle:nth-child(1) {
            width: 80px;
            height: 80px;
            background: radial-gradient(circle, rgba(102, 126, 234, 0.3), transparent);
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }

        .particle:nth-child(2) {
            width: 60px;
            height: 60px;
            background: radial-gradient(circle, rgba(245, 87, 108, 0.3), transparent);
            top: 60%;
            left: 80%;
            animation-delay: 5s;
        }

        .particle:nth-child(3) {
            width: 100px;
            height: 100px;
            background: radial-gradient(circle, rgba(138, 122, 255, 0.2), transparent);
            top: 80%;
            left: 20%;
            animation-delay: 10s;
        }

        @keyframes float-particle {
            0%, 100% {
                transform: translate(0, 0) scale(1);
            }
            25% {
                transform: translate(50px, -50px) scale(1.1);
            }
            50% {
                transform: translate(-30px, -80px) scale(0.9);
            }
            75% {
                transform: translate(40px, -20px) scale(1.05);
            }
        }

        @media (max-width: 991px) {
            body {
                padding-top: 70px;
            }

            .navbar-nav {
                padding-top: 20px;
                gap: 10px;
            }

            .nav-link {
                margin: 8px 0;
                text-align: center;
            }

            .d-flex.align-items-center {
                margin-top: 15px;
                flex-direction: column;
                gap: 10px !important;
            }

            .btn-frontend,
            .user-dropdown,
            .btn-login {
                width: 100%;
                justify-content: center;
            }

            .container-main {
                padding: 30px 20px;
            }

            .footer-content {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }

            .footer-links {
                flex-direction: column;
                gap: 10px;
            }
        }

        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.4rem;
            }

            .container-main {
                border-radius: 25px;
                margin-top: 25px;
            }
        }

        ::-webkit-scrollbar {
            width: 10px;
        }

        ::-webkit-scrollbar-track {
            background: #0f0f1e;
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, #764ba2, #f093fb);
        }
    </style>
</head>

<body>
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>

    <nav class="navbar navbar-expand-lg admin-navbar">
        <div class="container">
            <a class="navbar-brand" href="/auth/dashboard">ADMIN PANEL</a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() === 'auth/dashboard' ? 'active' : '' ?>" href="/auth/dashboard">
                            Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() === 'admin' ? 'active' : '' ?>" href="/auth/manage">
                            Manage Admin
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() === 'auth/biodata' ? 'active' : '' ?>" href="/auth/biodata">
                            Biodata
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() === 'auth/pendidikan' ? 'active' : '' ?>" href="/auth/pendidikan">
                            Pendidikan
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() === 'auth/aktivitas' ? 'active' : '' ?>" href="/auth/aktivitas">
                            Aktivitas
                        </a>
                    </li>
                </ul>

                <div class="d-flex align-items-center gap-2">
                    <a href="/" class="btn-frontend">
                        <span>←</span>
                        <span>Frontend</span>
                    </a>
                    
                    <?php if (session()->get('isLoggedIn')): ?>
                        <div class="dropdown">
                            <button class="user-dropdown dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <div class="user-icon">👤</div>
                                <span><?= session()->get('admin_username') ?></span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li>
                                    <a class="dropdown-item text-danger" href="/logout">
                                        🚪 Logout
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <a href="/login" class="btn-login">Login</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <div class="container container-main">